class HellSLV expands AntiSlv config(UTjetV2);

var Actor Seeking;
var config int CheckRadius;
var config bool bTeamColoredNuke;
var bool bInCheck;
var() int MyTeam;

var bool bSeekNuke;
var bool bDroppableNuke;

var config bool bIgnoreFriendlyDam;

var NukeBurner XNUkeTrailA;
var NukeBurnLight XNukeTrailB;

var config bool bNukeAutoAim;

replication
{
  unreliable if (role == ROLE_Authority)
		Seeking, MyTeam;
}

simulated function timer()
{
     local vector x,y,z;
     local float bestDist, bestAim;
     local vector SeekingDir;
     local float MagnitudeVel;
     local DamagePuff b;    //ut_SpriteSmokePuff
     local Pawn pilot;     // pawn(owner) Pilot;
     local actor other;
     local Pawn p;
    
     //If (bSeekNuke)
     If ( bNukeAutoAim )
     {
     If (Seeking==None)
     {     
          bestAim = 0.85;//0.93
	  bestDist = CheckRadius;
          seeking = instigator.PickTarget(bestAim, bestDist, Normal(Velocity), Location);
     }
     If (Seeking != None  && Seeking != Instigator) 
     { 
          SeekingDir = Normal(Seeking.Location - Location);
               MagnitudeVel = VSize(Velocity);
               Velocity =  MagnitudeVel * Normal(SeekingDir * 2.0 * MagnitudeVel + Velocity);               
		SetRotation(rotator(Velocity));
     }
     }

	if (!bDroppableNuke)
		Velocity = Speed * vector(Rotation);
            
     //if ( Trail == None )
          //Trail = Spawn(class'RedeemerTrail',self);

     CannonTimer += SmokeRate;
     if ( CannonTimer > 0.6 )
     {
          WarnCannons();
          CannonTimer -= 0.6;
     }

     if ( Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer) )
     {
          SetTimer(SmokeRate, false);
          Return;
     }

     if (!bDroppableNuke)
     {
     if ( Level.bHighDetailMode )
     {
          if ( Level.bDropDetail )
               Spawn(Class'DamagePuff');
          else
               Spawn(Class'DamagePuff');
          SmokeRate = 152/Speed; 
     }
     else 
     {
          SmokeRate = 0.15;

          b = Spawn(Class'DamagePuff');
          b.RemoteRole = ROLE_None;
     }
     }

     SetTimer(SmokeRate, false);

	
}

simulated function Destroyed()
{
     /*if ( Trail != None )
          Trail.Destroy();*/

	if (XNUkeTrailA != None)
		XNUkeTrailA.Destroy();
	if (XNUkeTrailB != None)
		XNUkeTrailB.Destroy();

     Super.Destroyed();
}

function WarnCannons()
{
     local Pawn P;

     for ( P=Level.Pawnlist; P!=None; P=P.NextPawn )
          if ( P.IsA('TeamCannon') && !P.IsInState('TrackWarhead') && P.LineOfSightTo(self) )
          {
               P.target = self;
               P.GotoState('TrackWarhead');
          }

}

singular function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
                              vector momentum, name damageType )
{
     if (NDamage > 5 && ((bIgnoreFriendlyDam && Instigator.PlayerReplicationInfo.Team!=instigatedBy.PlayerReplicationInfo.Team) ||
	!bIgnoreFriendlyDam || Instigator == instigatedBy))
     {
          PlaySound(Sound'Expl03',,6.0);
          spawn(class'WarExplosion',,,Location);
          
          HurtRadius(Damage,350.0, MyDamageType, MomentumTransfer, HitLocation );
          RemoteRole = ROLE_SimulatedProxy;                           
           Destroy();
     }
}

function Landed(vector HitNormal )
{
	HitWall(HitNormal, None);
}



auto state Flying
{

     simulated function ZoneChange( Zoneinfo NewZone )
     {
          local waterring w;
          
          if ( NewZone.bWaterZone != Region.Zone.bWaterZone )

          {
               w = Spawn(class'WaterRing',,,,rot(16384,0,0));
               w.DrawScale = 0.2;
               w.RemoteRole = ROLE_None; 
          }     

     }
     
     function ProcessTouch (Actor Other, Vector HitLocation)
     {
          if ( Other != instigator && !Other.IsA('StrangeShell')) 
               Explode(HitLocation,Normal(HitLocation-Other.Location));
	  else if (Other.IsA('StrangeShell'))
	  {
		if (Other.Instigator != Instigator)
			Explode(HitLocation,Normal(HitLocation-Other.Location));
	  }
     }

     function Explode(vector HitLocation, vector HitNormal)
     {
          if ( Role < ROLE_Authority )
               return;

        //HurtRadius(Damage,300.0, MyDamageType, MomentumTransfer, HitLocation );    
        spawn(class'StrangeWave',,, location);
        spawn(class'BlackCloud',,, location);
        RemoteRole = ROLE_SimulatedProxy;                           
           Destroy();
     }

     function BeginState()
     {
          local vector InitialDir;

		if (bTeamColoredNuke && Instigator.PlayerReplicationInfo.Team <= 3 && !bDroppableNuke)
		{
			if (Instigator.PlayerReplicationInfo.Team == 0)
			{
				XNUkeTrailA = Spawn(Class'RedNukeBurner', Self);
				XNUkeTrailB = Spawn(Class'RedNukeBurnLight', Self);
				LightHue = 0;
				LightSaturation = 0;
			}
			else if (Instigator.PlayerReplicationInfo.Team == 1)
			{
				XNUkeTrailA = Spawn(Class'BlueNukeBurner', Self);
				XNUkeTrailB = Spawn(Class'BlueNukeBurnLight', Self);
				LightHue = 170;
				LightSaturation = 127;
			}
			else if (Instigator.PlayerReplicationInfo.Team == 2)
			{
				XNUkeTrailA = Spawn(Class'GreenNukeBurner', Self);
				XNUkeTrailB = Spawn(Class'GreenNukeBurnLight', Self);
				LightHue = 85;
				LightSaturation = 64;
			}
			else
			{
				XNUkeTrailA = Spawn(Class'YellowNukeBurner', Self);
				XNUkeTrailB = Spawn(Class'YellowNukeBurnLight', Self);
				LightHue = 42;
				LightSaturation = 83;
			}
		}
		else if (!bDroppableNuke)
		{
			XNUkeTrailA = Spawn(Class'NukeBurner', Self);
			XNUkeTrailB = Spawn(Class'NukeBurnLight', Self);
		}

	if (bDroppableNuke)
		SetPhysics(PHYS_Falling);
	else
	{
          initialDir = vector(Rotation);
          if ( Role == ROLE_Authority )     
               Velocity = speed*initialDir;
          Acceleration = initialDir*50;
	}
     }
}

defaultproperties
{
    CheckRadius=64
    bTeamColoredNuke=True
    bSeekNuke=False
    bNukeAutoAim=False
    bIgnoreFriendlyDam=True
    speed=1720.00
    MaxSpeed=1720.00
    MyDamageType=RedeemerDeath
    ImpactSound=Sound'SLV2Sounds.Rocket.detonate'
    MiscSound=Sound'SLV2Sounds.Rocket.Warning'
    LifeSpan=0.00
    AmbientSound=Sound'NemesisWINGSvXc.NukeAmb.NukeAmb'
    //Mesh=LodMesh'NukeMissileA'
    Mesh=LodMesh'JetXRed'
    DrawScale=1.35
    AmbientGlow=78
    SoundRadius=255
    SoundPitch=104
    TransientSoundVolume=2.00
    CollisionRadius=15.00
    CollisionHeight=8.00
    bProjTarget=True
    LightBrightness=131
    LightHue=85
    LightSaturation=32
    LightRadius=24
    Mass=135.00
}
